<?php
session_start();
require_once 'db_connect.php';
require_once 'includes/notification_helper.php'; // 确保包含通知辅助函数

// 确保数据库连接变量名正确
if (!isset($pdo) && isset($conn)) {
    $pdo = $conn;
}

// 检查是否提交了表单
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 获取表单数据
    $reporter_name = $_POST['reporter_name'];
    $reporter_contact = $_POST['reporter_contact'];
    $report_type = $_POST['report_type'];
    $report_content = $_POST['report_content'];
    $reported_url = isset($_POST['reported_url']) ? $_POST['reported_url'] : '';
    
    // 获取当前登录用户ID（如果已登录）
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
    
    // 处理文件上传
    $evidence_file_path = '';
    if (isset($_FILES['evidence_file']) && $_FILES['evidence_file']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = 'uploads/evidence/';
        
        // 确保上传目录存在
        if (!file_exists($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        
        // 生成唯一文件名
        $file_extension = pathinfo($_FILES['evidence_file']['name'], PATHINFO_EXTENSION);
        $unique_filename = uniqid('evidence_') . '.' . $file_extension;
        $evidence_file_path = $upload_dir . $unique_filename;
        
        // 移动上传的文件
        if (!move_uploaded_file($_FILES['evidence_file']['tmp_name'], $evidence_file_path)) {
            header("Location: index.php?error=文件上传失败");
            exit;
        }
    }
    
    try {
        // 准备SQL语句，添加user_id字段
        $stmt = $conn->prepare("INSERT INTO reports (reporter_name, reporter_contact, report_type, report_content, reported_url, evidence_file, status, created_at, user_id) VALUES (?, ?, ?, ?, ?, ?, 'pending', NOW(), ?)");
        $stmt->bind_param("ssssssi", $reporter_name, $reporter_contact, $report_type, $report_content, $reported_url, $evidence_file_path, $user_id);
        
        // 执行SQL
        // 在成功提交举报后，修改重定向到成功页面
        // 在成功提交举报后，发送通知
        if ($stmt->execute()) {
            // 获取新插入的举报ID
            $report_id = $pdo instanceof PDO ? $pdo->lastInsertId() : $pdo->insert_id;
            
            // 获取完整的举报信息
            if ($pdo instanceof PDO) {
                $get_report = $pdo->prepare("SELECT * FROM reports WHERE id = ?");
                $get_report->execute([$report_id]);
                $report = $get_report->fetch(PDO::FETCH_ASSOC);
            } else {
                $get_report = $pdo->prepare("SELECT * FROM reports WHERE id = ?");
                $get_report->bind_param("i", $report_id);
                $get_report->execute();
                $result = $get_report->get_result();
                $report = $result->fetch_assoc();
            }
            
            // 发送通知
            if ($report) {
                send_new_report_notification($report);
            }
            
            // 重定向到成功页面
            header("Location: report_success.php?id=" . $report_id);
            exit;
        } else {
            header("Location: index.php?error=提交失败，请稍后再试");
            exit;
        }
    } catch (Exception $e) {
        header("Location: index.php?error=系统错误，请稍后再试");
        exit;
    }
} else {
    // 如果不是POST请求，重定向到首页
    header("Location: index.php");
    exit;
}
?>