<?php
session_start();
require_once 'db_connect.php';

// 确保数据库连接变量名正确
if (!isset($pdo) && isset($conn)) {
    $pdo = $conn;
}

// 获取举报ID
$report_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$report = null;

// 如果有举报ID，尝试获取举报信息
if ($report_id > 0) {
    try {
        if ($pdo instanceof PDO) {
            // PDO方式
            $stmt = $pdo->prepare("SELECT * FROM reports WHERE id = ?");
            $stmt->execute([$report_id]);
            $report = $stmt->fetch(PDO::FETCH_ASSOC);
        } else {
            // mysqli方式
            $stmt = $pdo->prepare("SELECT * FROM reports WHERE id = ?");
            $stmt->bind_param("i", $report_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $report = $result->fetch_assoc();
        }
    } catch (Exception $e) {
        // 错误处理
    }
}
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>举报提交成功 - 举报系统</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            padding-top: 20px;
            padding-bottom: 20px;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            background-attachment: fixed;
            position: relative;
        }
        
        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('https://cdn.pixabay.com/photo/2018/03/22/02/37/background-3249063_1280.png');
            background-size: cover;
            background-position: center;
            opacity: 0.1;
            z-index: -1;
        }
        
        .container {
            max-width: 800px;
            position: relative;
            z-index: 1;
        }
        
        .card {
            border-radius: 10px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            border: none;
            background-color: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(5px);
        }
        
        .card-body {
            padding: 30px;
        }
        
        h1 {
            color: #0d6efd;
            font-weight: 600;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.1);
        }
        
        .success-icon {
            font-size: 5rem;
            color: #198754;
            margin-bottom: 1rem;
        }
        
        .report-info {
            background-color: rgba(248, 249, 250, 0.7);
            border-radius: 8px;
            padding: 15px;
            margin-top: 20px;
            border: 1px solid #dee2e6;
        }
        
        .report-info-item {
            margin-bottom: 10px;
        }
        
        .report-info-item .label {
            font-weight: 600;
            color: #495057;
        }
        
        .btn-home {
            background-color: #0d6efd;
            border: none;
            padding: 10px 20px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-home:hover {
            background-color: #0b5ed7;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
        }
        
        .user-links {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 20px;
        }
        
        .user-link {
            color: #6c757d;
            text-decoration: none;
            margin-left: 15px;
            transition: color 0.3s;
        }
        
        .user-link:hover {
            color: #0d6efd;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="user-links">
            <?php
            if(isset($_SESSION['user_id'])) {
                echo '<span class="me-2">欢迎, ' . htmlspecialchars($_SESSION['username']) . '</span>';
                echo '<a href="user_dashboard.php" class="user-link me-2"><i class="bi bi-person-circle me-1"></i>用户平台</a>';
                echo '<a href="logout.php" class="user-link"><i class="bi bi-box-arrow-right me-1"></i>退出登录</a>';
            } else {
                echo '<a href="login.php" class="user-link me-2"><i class="bi bi-person me-1"></i>登录</a>';
                echo '<a href="register.php" class="user-link"><i class="bi bi-person-plus me-1"></i>注册</a>';
            }
            ?>
        </div>
        
        <div class="card mb-4">
            <div class="card-body text-center">
                <div class="success-icon">
                    <i class="bi bi-check-circle-fill"></i>
                </div>
                <h1 class="mb-3">举报提交成功！</h1>
                <p class="lead mb-4">感谢您的举报，我们将尽快处理您的举报信息。</p>
                
                <?php if ($report): ?>
                <div class="report-info text-start">
                    <h5 class="mb-3">举报信息</h5>
                    
                    <div class="report-info-item">
                        <div class="label">举报编号</div>
                        <div><?php echo $report['id']; ?></div>
                    </div>
                    
                    <div class="report-info-item">
                        <div class="label">举报类型</div>
                        <div><?php echo htmlspecialchars($report['report_type']); ?></div>
                    </div>
                    
                    <div class="report-info-item">
                        <div class="label">提交时间</div>
                        <div><?php echo date('Y-m-d H:i:s', strtotime($report['created_at'])); ?></div>
                    </div>
                    
                    <div class="report-info-item">
                        <div class="label">当前状态</div>
                        <div>
                            <?php
                            $status_text = '待处理';
                            switch ($report['status']) {
                                case 'processing':
                                    $status_text = '处理中';
                                    break;
                                case 'resolved':
                                    $status_text = '已解决';
                                    break;
                                case 'rejected':
                                    $status_text = '已驳回';
                                    break;
                            }
                            echo $status_text;
                            ?>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <p>您可以在用户平台中查看举报处理进度。</p>
                    <?php if(isset($_SESSION['user_id'])): ?>
                    <a href="view_user_report.php?id=<?php echo $report['id']; ?>" class="btn btn-outline-primary me-2">
                        <i class="bi bi-eye me-1"></i>查看详情
                    </a>
                    <?php else: ?>
                    <p class="text-muted small">登录后可以查看举报处理进度</p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <div class="mt-4">
                    <a href="index.php" class="btn btn-primary btn-home">
                        <i class="bi bi-house-door me-2"></i>返回首页
                    </a>
                </div>
            </div>
        </div>
        
        <footer class="mt-5 text-center text-muted">
            <small>&copy; <?php echo date('Y'); ?> 举报系统 - 共建健康网络环境</small>
        </footer>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>