<?php
session_start();
require_once 'db_connect.php';

// 检查是否提交了表单
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    
    // 验证输入
    if (empty($username) || empty($password)) {
        header("Location: login.php?error=请填写所有必填字段");
        exit;
    }
    
    try {
        // 查询用户
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        // 验证用户和密码
        if ($user && password_verify($password, $user['password'])) {
            // 登录成功，设置会话
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            
            // 重定向到首页
            header("Location: index.php");
            exit;
        } else {
            // 登录失败
            header("Location: login.php?error=用户名或密码不正确");
            exit;
        }
    } catch (PDOException $e) {
        header("Location: login.php?error=系统错误，请稍后再试");
        exit;
    }
} else {
    // 如果不是POST请求，重定向到登录页面
    header("Location: login.php");
    exit;
}
?>