CREATE DATABASE report_system;
USE report_system;

CREATE TABLE reports (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    reporter_name VARCHAR(100) NOT NULL,
    reporter_contact VARCHAR(100) NOT NULL,
    report_type VARCHAR(50) NOT NULL,
    report_content TEXT NOT NULL,
    reported_url VARCHAR(255),
    evidence_file VARCHAR(255),
    status ENUM('pending', 'processing', 'resolved', 'rejected') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE admin_users (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- 插入默认管理员账号 (用户名: admin, 密码: admin123)
-- 使用明文密码，在PHP登录验证时使用password_verify()函数
INSERT INTO admin_users (username, password) VALUES ('admin', 'admin123');