<?php
// 检查是否有文件上传
if(isset($_FILES['logo_file']) && $_FILES['logo_file']['error'] == 0) {
    // 检查文件类型
    $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
    if(!in_array($_FILES['logo_file']['type'], $allowed_types)) {
        header("Location: index.php?error=只允许上传JPG、PNG或GIF格式的图片");
        exit;
    }
    
    // 检查文件大小 (最大2MB)
    $max_size = 2 * 1024 * 1024;
    if($_FILES['logo_file']['size'] > $max_size) {
        header("Location: index.php?error=Logo图片大小不能超过2MB");
        exit;
    }
    
    // 确保上传目录存在
    $upload_dir = 'uploads/';
    if(!file_exists($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }
    
    // 保存文件为logo.png
    $target_file = $upload_dir . 'logo.png';
    
    // 如果已存在旧logo，先删除
    if(file_exists($target_file)) {
        unlink($target_file);
    }
    
    // 移动上传的文件
    if(move_uploaded_file($_FILES['logo_file']['tmp_name'], $target_file)) {
        header("Location: index.php?success=logo");
        exit;
    } else {
        header("Location: index.php?error=Logo上传失败，请稍后重试");
        exit;
    }
} else {
    header("Location: index.php?error=请选择要上传的Logo图片");
    exit;
}
?>