<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '未授权访问']);
    exit;
}

// 获取POST数据
$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['webhook_url']) || empty($data['webhook_url'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '缺少Webhook地址']);
    exit;
}

$webhook_url = $data['webhook_url'];

// 验证Webhook URL格式
if (!filter_var($webhook_url, FILTER_VALIDATE_URL)) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Webhook地址格式不正确']);
    exit;
}

// 构建测试消息
$message = [
    'msgtype' => 'markdown',
    'markdown' => [
        'content' => "# 举报系统通知测试\n\n".
                     "> 这是一条测试消息，用于验证企业微信机器人通知功能是否正常工作。\n\n".
                     "- **系统名称**：举报系统\n".
                     "- **测试时间**：".date('Y-m-d H:i:s')."\n".
                     "- **测试用户**：".htmlspecialchars($_SESSION['admin_username'])."\n\n".
                     "如果您收到此消息，说明企业微信机器人通知功能配置正确。"
    ]
];

// 发送请求到企业微信API
$ch = curl_init($webhook_url);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($error) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '请求失败: ' . $error]);
    exit;
}

$response_data = json_decode($response, true);

// 企业微信API返回0表示成功
if (isset($response_data['errcode']) && $response_data['errcode'] === 0) {
    header('Content-Type: application/json');
    echo json_encode(['success' => true]);
} else {
    $error_message = isset($response_data['errmsg']) ? $response_data['errmsg'] : '未知错误';
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '企业微信API返回错误: ' . $error_message]);
}