<?php
// 启动会话
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '未授权访问'
    ]);
    exit;
}

// 引入必要的文件
require_once '../includes/Notification.php';

// 检查请求方法
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '无效的请求方法'
    ]);
    exit;
}

// 获取Webhook URL
$webhook_url = $_POST['webhook_url'] ?? '';

// 记录请求信息
error_log('测试企业微信通知，Webhook URL: ' . $webhook_url);

try {
    // 发送测试通知
    $notification = new Notification();
    $result = $notification->sendTestWechatNotification($webhook_url);
    
    // 返回结果
    header('Content-Type: application/json');
    echo json_encode($result);
} catch (Exception $e) {
    // 记录异常
    error_log('测试企业微信通知异常: ' . $e->getMessage());
    
    // 返回错误信息
    header('Content-Type: application/json');
    echo json_encode([
        'success' => false,
        'message' => '发送通知时发生异常: ' . $e->getMessage()
    ]);
}