<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '未授权访问']);
    exit;
}

require_once '../db_connect.php';

// 检查是否提供了用户ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '无效的用户ID']);
    exit;
}

$user_id = (int)$_GET['id'];

try {
    // 获取用户信息
    $stmt = $conn->prepare("SELECT id, username, email, created_at, updated_at FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    
    if (!$user) {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => '用户不存在']);
        exit;
    }
    
    // 获取用户提交的举报数量
    $stmt = $conn->prepare("SELECT COUNT(*) as report_count FROM reports WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $report_data = $result->fetch_assoc();
    $report_count = $report_data ? $report_data['report_count'] : 0;
    
    // 返回用户信息和举报数量
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true, 
        'user' => $user,
        'report_count' => $report_count
    ]);
    
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '获取用户信息失败: ' . $e->getMessage()]);
}
?>