<?php
session_start();

// 检查是否已登录
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '未授权访问']);
    exit;
}

require_once '../db_connect.php';

// 检查是否提供了用户ID
if (!isset($_POST['id']) || !is_numeric($_POST['id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '无效的用户ID']);
    exit;
}

$user_id = (int)$_POST['id'];

try {
    // 开始事务
    $conn->begin_transaction();
    
    // 先删除用户相关的举报记录
    $stmt = $conn->prepare("DELETE FROM reports WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    
    // 删除用户
    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    
    // 检查是否成功删除用户
    if ($stmt->affected_rows === 0) {
        // 回滚事务
        $conn->rollback();
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => '用户不存在或删除失败']);
        exit;
    }
    
    // 提交事务
    $conn->commit();
    
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'message' => '用户已成功删除']);
    
} catch (Exception $e) {
    // 发生错误时回滚事务
    $conn->rollback();
    
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => '删除用户失败: ' . $e->getMessage()]);
}
?>