# 系统简介

本系统为举报管理平台，支持用户注册、登录、提交举报、查看举报进度，并支持管理员后台管理、通知设置等功能。系统基于PHP开发，使用MySQL数据库，集成邮件通知功能。

## 主要功能
- 用户注册与登录
- 举报信息提交与进度查询
- 管理员后台管理（用户管理、举报审核、通知设置等）
- 邮件通知与微信通知支持
- 支持Logo上传、密码修改等

## 安装与部署
1. 克隆或下载本项目源码至服务器目录。
2. 配置Web服务器（如Apache/Nginx），确保支持PHP 7.2及以上版本。
3. 导入`database.sql`文件至MySQL数据库，配置数据库连接信息（见`db_connect.php`）。
4. 安装依赖：
   - 通过Composer安装依赖：`composer install`
   - 主要依赖：PHPMailer（已包含在vendor目录）
5. 配置邮件通知、微信通知等参数（见`config/notification_settings.php`）。
6. 设置目录权限，确保`upload_logo.php`等上传功能可用。

## 依赖说明
- PHP >= 7.2
- MySQL >= 5.6
- Composer（用于依赖管理）
- PHPMailer（邮件发送）

## 目录结构说明
- `admin/` 管理后台相关页面及逻辑
- `config/` 配置文件（如通知设置）
- `includes/` 公共类与辅助函数
- `vendor/` 第三方依赖（如PHPMailer）
- `database.sql` 数据库结构文件
- `index.php` 系统首页
- 其它如`login.php`、`register.php`等为主要业务页面

## 常见问题
1. **邮件发送失败？**
   - 检查`config/notification_settings.php`中的SMTP配置是否正确。
   - 确认服务器防火墙未阻止相关端口。
2. **无法上传Logo？**
   - 检查`upload_logo.php`及相关目录权限。
3. **数据库连接异常？**
   - 检查`db_connect.php`中的数据库配置。

## 联系与支持
如有问题或建议，请联系系统管理员或提交Issue。